from jade_gui.classes.keymap import Keymap

keymaps = [
    Keymap(
        layout="Afghanistan",
        backend_layout="af",
        variants=[
            "normal",
            "fa-olpc",
            "olpc-ps",
            "ps",
            "uz",
            "uz-olpc",
        ],
    ),
    Keymap(
        layout="Albania",
        backend_layout="al",
        variants=[
            "normal",
            "plisi",
            "veqilharxhi",
        ],
    ),
    Keymap(
        layout="Armenia",
        backend_layout="am",
        variants=[
            "normal",
            "eastern",
            "eastern-alt",
            "phonetic",
            "phonetic-alt",
            "western",
        ],
    ),
    Keymap(
        layout="Arabic",
        backend_layout="ara",
        variants=[
            "normal",
            "azerty",
            "azerty_digits",
            "buckwalter",
            "digits",
            "mac",
            "olpc",
            "qwerty",
            "qwerty_digits",
        ],
    ),
    Keymap(
        layout="Austria",
        backend_layout="at",
        variants=[
            "normal",
            "mac",
            "nodeadkeyrs",
        ],
    ),
    Keymap(
        layout="Australia",
        backend_layout="au",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Azerbaijan",
        backend_layout="az",
        variants=[
            "normal",
            "cyrillic",
        ],
    ),
    Keymap(
        layout="Bosnia and Herzegovina",
        backend_layout="ba",
        variants=[
            "normal",
            "alternatequotes",
            "unicode",
            "unicodeus",
            "us",
        ],
    ),
    Keymap(
        layout="Bangladesh",
        backend_layout="bd",
        variants=[
            "normal",
            "probhat",
        ],
    ),
    Keymap(
        layout="Belgium",
        backend_layout="be",
        variants=[
            "normal",
            "iso-alternate",
            "nodeadkeys",
            "oss",
            "oss_latin9",
            "wang",
        ],
    ),
    Keymap(
        layout="Bulgaria",
        backend_layout="bg",
        variants=[
            "normal",
            "bas_phonetic",
            "bekl",
            "phonetic",
        ],
    ),
    Keymap(
        layout="Brazil",
        backend_layout="br",
        variants=[
            "normal",
            "dvorak",
            "nativo",
            "nativo-epo",
            "nativo-us",
            "nodeadkeys",
            "thinkpad",
        ],
    ),
    Keymap(
        layout="Bhutan",
        backend_layout="bt",
        variants=[
            "normal",
            "latin",
        ],
    ),
    Keymap(
        layout="Botswana",
        backend_layout="bw",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Belarus",
        backend_layout="by",
        variants=[
            "normal",
            "intl",
            "latin",
            "legacy",
            "ru",
        ],
    ),
    Keymap(
        layout="Canada",
        backend_layout="ca",
        variants=[
            "normal",
            "eng",
            "fr-dvorak",
            "fr-legacy",
            "ike",
            "multi",
            "multi-2gr",
            "multix",
        ],
    ),
    Keymap(
        layout="Democratic Republic of Congo",
        backend_layout="cd",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Switzerland",
        backend_layout="ch",
        variants=[
            "normal",
            "de_mac",
            "de_nodeadkeys",
            "fr",
            "fr_mac",
            "fr_nodeadkeys",
            "legacy",
        ],
    ),
    Keymap(
        layout="Cameroon",
        backend_layout="cm",
        variants=[
            "normal",
            "azerty",
            "dvorak",
            "french",
            "mmuock",
            "qwerty",
        ],
    ),
    Keymap(
        layout="China",
        backend_layout="cn",
        variants=[
            "normal",
            "altgr-pinyin",
            "mon_manchu_galik",
            "mon_todo_galik",
            "mon_trad",
            "mon_trad_galik",
            "mon_trad_manchu",
            "mon_trad_todo",
            "mon_trad_xibe",
            "tib",
            "tib_asciinum",
            "ug",
        ],
    ),
    Keymap(
        layout="Czechia",
        backend_layout="cz",
        variants=[
            "normal",
            "bksl",
            "dvorak-ucw",
            "qwerty",
            "qwerty-mac",
            "qwerty_bksl",
            "rus",
            "ucw",
        ],
    ),
    Keymap(
        layout="Germany",
        backend_layout="de",
        variants=[
            "normal",
            "T3",
            "deadacute",
            "deadgraveacute",
            "deadtilde",
            "dsb",
            "dsb_qwertz",
            "dvorak",
            "e1",
            "e2",
            "mac",
            "mac_nodeadkeys",
            "neo",
            "nodeadkeys",
            "qwerty",
            "ro",
            "ro_nodeadkeys",
            "ru",
            "tr",
            "us",
        ],
    ),
    Keymap(
        layout="Denmark",
        backend_layout="dk",
        variants=[
            "normal",
            "dvorak",
            "mac",
            "mac_nodeadkeys",
            "nodeadkeys",
            "winkeys",
        ],
    ),
    Keymap(
        layout="Algeria",
        backend_layout="dz",
        variants=[
            "normal",
            "ar",
            "azerty-deadkeys",
            "ber",
            "qwerty-gb-deadkeys",
            "qwerty-us-deadkeys",
        ],
    ),
    Keymap(
        layout="Estonia",
        backend_layout="ee",
        variants=[
            "normal",
            "dvorak",
            "nodeadkeys",
            "us",
        ],
    ),
    Keymap(
        layout="Spain",
        backend_layout="es",
        variants=[
            "normal",
            "ast",
            "cat",
            "deadtilde",
            "dvorak",
            "mac",
            "nodeadkeys",
            "winkeys",
        ],
    ),
    Keymap(
        layout="Ethiopia",
        backend_layout="et",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Finland",
        backend_layout="fi",
        variants=[
            "normal",
            "normal" "classic",
            "mac",
            "nodeadkeys",
            "smi",
            "winkeys",
        ],
    ),
    Keymap(
        layout="Faroe Islands",
        backend_layout="fo",
        variants=[
            "normal",
            "nodeadkeys",
        ],
    ),
    Keymap(
        layout="France",
        backend_layout="fr",
        variants=[
            "normal",
            "afnor",
            "azerty",
            "bepo",
            "bepo_afnor",
            "bepo_latin9",
            "bre",
            "dvorak",
            "geo",
            "latin9",
            "latin9_nodeadkeys",
            "mac",
            "nodeadkeys",
            "oci",
            "oss",
            "oss_latin9",
            "oss_nodeadkeys",
            "us",
        ],
    ),
    Keymap(
        layout="Great Britain",
        backend_layout="gb",
        variants=[
            "normal",
            "colemak",
            "colemak_dh",
            "dvorak",
            "dvorakukp",
            "extd",
            "intl",
            "mac",
            "mac_intl",
            "pl",
        ],
    ),
    Keymap(
        layout="Georgia",
        backend_layout="ge",
        variants=[
            "normal",
            "ergonomic",
            "mess",
            "os",
            "ru",
        ],
    ),
    Keymap(
        layout="Ghana",
        backend_layout="gh",
        variants=[
            "normal",
            "akan",
            "avn",
            "ewe",
            "fula",
            "ga",
            "generic",
            "gillbt",
            "hausa",
        ],
    ),
    Keymap(
        layout="Guinea",
        backend_layout="gn",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Greece",
        backend_layout="gr",
        variants=[
            "normal",
            "extended",
            "nodeadkeys",
            "polytonic",
            "simple",
        ],
    ),
    Keymap(
        layout="Croatia",
        backend_layout="hr",
        variants=[
            "normal",
            "alternatequotes",
            "unicode",
            "unicodeus",
            "us",
        ],
    ),
    Keymap(
        layout="Hungary",
        backend_layout="hu",
        variants=[
            "normal",
            "101_qwerty_comma_dead",
            "101_qwerty_comma_nodead",
            "101_qwerty_dot_dead",
            "101_qwerty_dot_nodead",
            "101_qwertz_comma_dead",
            "101_qwertz_comma_nodead",
            "101_qwertz_dot_dead",
            "101_qwertz_dot_nodead",
            "102_qwerty_comma_dead",
            "102_qwerty_comma_nodead",
            "102_qwerty_dot_dead",
            "102_qwerty_dot_nodead",
            "102_qwertz_comma_dead",
            "102_qwertz_comma_nodead",
            "102_qwertz_dot_dead",
            "102_qwertz_dot_nodead",
            "nodeadkeys",
            "qwerty",
            "standard",
        ],
    ),
    Keymap(
        layout="Indonesia",
        backend_layout="id",
        variants=[
            "normal",
            "phoneticx",
        ],
    ),
    Keymap(
        layout="Ireland",
        backend_layout="ie",
        variants=[
            "normal",
            "CloGaelach",
            "UnicodeExpert",
            "ogam",
            "ogam_is434",
        ],
    ),
    Keymap(
        layout="Israel",
        backend_layout="il",
        variants=[
            "normal",
            "biblical",
            "lyx",
            "phonetic",
        ],
    ),
    Keymap(
        layout="India",
        backend_layout="in",
        variants=[
            "normal",
            "ben",
            "ben_baishakhi",
            "ben_bornona",
            "ben_gitanjali",
            "ben_inscript",
            "ben_probhat",
            "bolnagri",
            "eeyek",
            "eng",
            "guj",
            "guru",
            "hin-kagapa",
            "hin-wx",
            "iipa",
            "jhelum",
            "kan",
            "kan-kagapa",
            "mal",
            "mal_enhanced",
            "mal_lalitha",
            "mar-kagapa",
            "marathi",
            "olck",
            "ori",
            "ori-bolnagri",
            "ori-wx",
            "san-kagapa",
            "tam",
            "tam_tamilnet",
            "tam_tamilnet_TAB",
            "tam_tamilnet_TSCII",
            "tam_tamilnet_with_tam_nums",
            "tel",
            "tel-kagapa",
            "tel-sarala",
            "urd-phonetic",
            "urd-phonetic3",
            "urd-winkeys",
        ],
    ),
    Keymap(
        layout="Iraq",
        backend_layout="iq",
        variants=[
            "normal",
            "ku",
            "ku_alt",
            "ku_ara",
            "ku_f",
        ],
    ),
    Keymap(
        layout="Iran",
        backend_layout="ir",
        variants=[
            "normal",
            "ku",
            "ku_alt",
            "ku_ara",
            "ku_f",
            "pes_keypad",
        ],
    ),
    Keymap(
        layout="Iceland",
        backend_layout="is",
        variants=[
            "normal",
            "ku",
            "ku_alt",
            "ku_ara",
            "ku_f",
            "pes_keypad",
        ],
    ),
    Keymap(
        layout="Italy",
        backend_layout="it",
        variants=[
            "normal",
            "fur",
            "geo",
            "ibm",
            "intl",
            "mac",
            "nodeadkeys",
            "scn",
            "us",
            "winkeys",
        ],
    ),
    Keymap(
        layout="Japan",
        backend_layout="jp",
        variants=[
            "normal",
            "OADG109A",
            "dvorak",
            "kana",
            "kana86",
            "mac",
        ],
    ),
    Keymap(
        layout="Kenya",
        backend_layout="ke",
        variants=[
            "normal",
            "kik",
        ],
    ),
    Keymap(
        layout="Kyrgyzstan",
        backend_layout="kg",
        variants=[
            "normal",
            "phonetic",
        ],
    ),
    Keymap(
        layout="Cambodia",
        backend_layout="kh",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="The Republic of Korea",
        backend_layout="kr",
        variants=[
            "normal",
            "kr104",
        ],
    ),
    Keymap(
        layout="Kazakhstan",
        backend_layout="kz",
        variants=[
            "normal",
            "ext",
            "kazrus",
            "latin",
            "ruskaz",
        ],
    ),
    Keymap(
        layout="Laos",
        backend_layout="la",
        variants=[
            "normal",
            "stea",
        ],
    ),
    Keymap(
        layout="Sri Lanka",
        backend_layout="lk",
        variants=[
            "normal",
            "tam_TAB",
            "tam_unicode",
            "us",
        ],
    ),
    Keymap(
        layout="Lithuania",
        backend_layout="lt",
        variants=[
            "normal",
            "ibm",
            "lekp",
            "lekpa",
            "ratise",
            "sgs",
            "std",
            "us",
        ],
    ),
    Keymap(
        layout="Latin America",
        backend_layout="la-latin1",
        variants=[
            "normal",
        ],
    ),
    Keymap(
        layout="Lativa",
        backend_layout="lv",
        variants=[
            "normal",
            "adapted",
            "apostrophe",
            "ergonomic",
            "fkey",
            "modern",
            "tilde",
        ],
    ),
    Keymap(
        layout="Morocco",
        backend_layout="ma",
        variants=[
            "normal",
            "french",
            "tifinagh",
            "tifinagh-alt",
            "tifinagh-alt-phonetic",
            "tifinagh-extended",
            "tifinagh-extended-phonetic",
            "tifinagh-phonetic",
        ],
    ),
    Keymap(
        layout="Moldova",
        backend_layout="md",
        variants=[
            "normal",
            "gag",
        ],
    ),
    Keymap(
        layout="Montenegro",
        backend_layout="me",
        variants=[
            "normal",
            "cyrillic",
            "cyrillicalternatequotes",
            "cyrillicyz",
            "latinalternatequotes",
            "latinunicode",
            "latinunicodeyz",
            "latinyz",
        ],
    ),
    Keymap(
        layout="Republic of North Macedonia",
        backend_layout="mk",
        variants=[
            "normal",
            "nodeadkeys",
        ],
    ),
    Keymap(
        layout="Mali",
        backend_layout="ml",
        variants=[
            "normal",
            "fr-oss",
            "us-intl",
            "us-mac",
        ],
    ),
    Keymap(
        layout="Myanmar",
        backend_layout="mm",
        variants=[
            "normal",
            "zawgyi",
        ],
    ),
    Keymap(
        layout="Mongolia",
        backend_layout="mn",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Malta",
        backend_layout="mt",
        variants=[
            "normal",
            "alt-gb",
            "alt-us",
            "us",
        ],
    ),
    Keymap(
        layout="Maldives",
        backend_layout="mv",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Malaysia",
        backend_layout="my",
        variants=[
            "normal",
            "phonetic",
        ],
    ),
    Keymap(
        layout="Nigeria",
        backend_layout="ng",
        variants=[
            "normal",
            "hausa",
            "igbo",
            "yoruba",
        ],
    ),
    Keymap(
        layout="Netherlands",
        backend_layout="nl",
        variants=[
            "normal",
            "mac",
            "std",
            "us",
        ],
    ),
    Keymap(
        layout="Norway",
        backend_layout="no",
        variants=[
            "normal",
            "colemak",
            "dvorak",
            "mac",
            "mac_nodeadkeys",
            "nodeadkeys",
            "smi",
            "smi_nodeadkeys",
            "winkeys",
        ],
    ),
    Keymap(
        layout="Nepal",
        backend_layout="np",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Philippines",
        backend_layout="ph",
        variants=[
            "normal",
            "capewell-dvorak",
            "capewell-dvorak-bay",
            "capewell-qwerf2k6",
            "capewell-qwerf2k6-bay",
            "colemak",
            "colemak-bay",
            "dvorak",
            "dvorak-bay",
            "qwerty-bay",
        ],
    ),
    Keymap(
        layout="Pakistan",
        backend_layout="pk",
        variants=[
            "normal",
            "ara",
            "snd",
            "urd-crulp",
            "urd-nla",
        ],
    ),
    Keymap(
        layout="Poland",
        backend_layout="pl",
        variants=[
            "normal",
            "csb",
            "dvorak",
            "dvorak_altquotes",
            "dvorak_quotes",
            "dvp",
            "legacy",
            "qwertz",
            "ru_phonetic_dvorak",
            "szl",
        ],
    ),
    Keymap(
        layout="Portugal",
        backend_layout="pt",
        variants=[
            "normal",
            "mac",
            "mac_nodeadkeys",
            "nativo",
            "nativo-epo",
            "nativo-us",
            "nodeadkeys",
        ],
    ),
    Keymap(
        layout="Romania",
        backend_layout="ro",
        variants=[
            "normal",
            "std",
            "winkeys",
        ],
    ),
    Keymap(
        layout="Serbia",
        backend_layout="rs",
        variants=[
            "normal",
            "alternatequotes",
            "latin",
            "latinalternatequotes",
            "latinunicode",
            "latinunicodeyz",
            "latinyz",
            "rue",
            "yz",
        ],
    ),
    Keymap(
        layout="Russia",
        backend_layout="ru",
        variants=[
            "normal",
            "bak",
            "chm",
            "cv",
            "cv_latin",
            "dos",
            "kom",
            "legacy",
            "mac",
            "os_legacy",
            "os_winkeys",
            "phonetic",
            "phonetic_YAZHERTY",
            "phonetic_azerty",
            "phonetic_dvorak",
            "phonetic_fr",
            "phonetic_winkeys",
            "sah",
            "srp",
            "tt",
            "typewriter",
            "typewriter-legacy",
            "udm",
            "xal",
        ],
    ),
    Keymap(
        layout="Sweden",
        backend_layout="se",
        variants=[
            "normal",
            "dvorak",
            "mac",
            "nodeadkeys",
            "rus",
            "rus_nodeadkeys",
            "smi",
            "svdvorak",
            "swl",
            "us",
            "us_dvorak",
        ],
    ),
    Keymap(
        layout="Slovenia",
        backend_layout="si",
        variants=[
            "normal",
            "alternatequotes",
            "us",
        ],
    ),
    Keymap(
        layout="Slovakia",
        backend_layout="sk",
        variants=[
            "normal",
            "bksl",
            "qwerty",
            "qwerty_bksl",
        ],
    ),
    Keymap(
        layout="Senegal",
        backend_layout="sn",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Sierra Leone",
        backend_layout="sl",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Syria",
        backend_layout="sy",
        variants=[
            "normal",
            "ku",
            "ku_alt",
            "ku_f",
            "syc",
            "syc_phonetic",
        ],
    ),
    Keymap(
        layout="Togo",
        backend_layout="tg",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Thailand",
        backend_layout="th",
        variants=[
            "normal",
            "pat",
            "tis",
        ],
    ),
    Keymap(
        layout="Tajikistan",
        backend_layout="tj",
        variants=[
            "normal",
            "legacy",
        ],
    ),
    Keymap(
        layout="Turkmenistan",
        backend_layout="tm",
        variants=[
            "normal",
            "alt",
        ],
    ),
    Keymap(
        layout="Turkey",
        backend_layout="tr",
        variants=[
            "normal",
            "alt",
            "crh",
            "crh_alt",
            "crh_f",
            "f",
            "intl",
            "ku",
            "ku_alt",
            "ku_f",
            "ot",
            "otf",
            "otk",
            "otkf",
        ],
    ),
    Keymap(
        layout="Taiwan",
        backend_layout="tw",
        variants=[
            "normal",
            "indigenous",
            "saisiyat",
        ],
    ),
    Keymap(
        layout="Tanzania",
        backend_layout="tz",
        variants=[
            "normal",
            "",
        ],
    ),
    Keymap(
        layout="Ukraine",
        backend_layout="ua",
        variants=[
            "normal",
            "homophonic",
            "legacy",
            "phonetic",
            "rstu",
            "rstu_ru",
            "typewriter",
            "winkeys",
        ],
    ),
    Keymap(
        layout="United States of America",
        backend_layout="us",
        variants=[
            "normal",
            "alt-intl",
            "altgr-intl",
            "chr",
            "colemak",
            "colemak_dh",
            "colemak_dh_iso",
            "dvorak",
            "dvorak-alt-intl",
            "dvorak-classic",
            "dvorak-intl",
            "dvorak-l",
            "dvorak-mac",
            "dvorak-r",
            "dvp",
            "euro",
            "haw",
            "hbs",
            "intl",
            "mac",
            "norman",
            "olpc2",
            "rus",
            "symbolic",
            "workman",
            "workman-intl",
        ],
    ),
    Keymap(
        layout="Uzbekistan",
        backend_layout="uz",
        variants=[
            "normal",
            "latin",
        ],
    ),
    Keymap(
        layout="Vietnam",
        backend_layout="vn",
        variants=[
            "normal",
            "fr",
            "us",
        ],
    ),
    Keymap(
        layout="South Africa",
        backend_layout="za",
        variants=[
            "normal",
            "",
        ],
    ),
]
